<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Service;
use Illuminate\Http\Request;

class ServiceController extends Controller
{
    public function index(Request $request)
    {
        $search = $request->get('search');
        
        $services = Service::active()
            ->free()
            ->when($search, function($query) use ($search) {
                $query->where(function($q) use ($search) {
                    $q->where('name', 'like', "%{$search}%")
                      ->orWhere('name_bn', 'like', "%{$search}%")
                      ->orWhere('short_description', 'like', "%{$search}%")
                      ->orWhere('short_description_bn', 'like', "%{$search}%");
                });
            })
            ->orderBy('sort_order')
            ->paginate(12);

        return view('services.index', compact('services', 'search'));
    }

    public function show($slug)
    {
        $service = Service::active()
            ->with(['links' => function($query) {
                $query->active()->orderBy('sort_order');
            }])
            ->where('slug', $slug)
            ->firstOrFail();

        if ($service->type === 'paid') {
            return view('services.paid-detail', compact('service'));
        }

        return view('services.free-detail', compact('service'));
    }

    public function category($slug)
    {
        $category = Category::active()
            ->where('slug', $slug)
            ->firstOrFail();

        $services = $category->activeServices()
            ->orderBy('sort_order')
            ->paginate(12);

        return view('services.category', compact('category', 'services'));
    }

    public function freeServices()
    {
        $categories = Category::active()
            ->free()
            ->with(['activeServices' => function($query) {
                $query->orderBy('sort_order');
            }])
            ->orderBy('sort_order')
            ->get();

        return view('services.free', compact('categories'));
    }

    public function paidServices()
    {
        $services = Service::active()
            ->paid()
            ->orderBy('sort_order')
            ->paginate(12);

        return view('services.paid', compact('services'));
    }
}
