<?php

namespace Database\Seeders;

use App\Models\Category;
use App\Models\Service;
use App\Models\ServiceLink;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        // Create Admin User
        User::create([
            'name' => 'Admin',
            'email' => 'admin@mamuneservice.com',
            'password' => Hash::make('admin123'),
            'phone' => '+8801886191222',
            'role' => 'admin',
        ]);

        // Create Categories
        $categories = [
            [
                'name' => 'Citizen Services',
                'name_bn' => 'নাগরিক সেবা',
                'slug' => 'nagorik-seba',
                'description' => 'Birth registration, NID, passport application and all government citizen services.',
                'description_bn' => 'জন্ম নিবন্ধন, NID, পাসপোর্ট আবেদন সহ সকল সরকারি নাগরিক সেবা।',
                'icon' => 'fas fa-id-card',
                'type' => 'free',
                'is_active' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'Education Services',
                'name_bn' => 'শিক্ষা সেবা',
                'slug' => 'shikkha-seba',
                'description' => 'SSC, HSC, NU exam results, university admission, scholarships, e-books, teacher registration.',
                'description_bn' => 'SSC, HSC, NU পরীক্ষার ফলাফল, বিশ্ববিদ্যালয় ভর্তি, উপবৃত্তি, ইবুক, শিক্ষক নিবন্ধন সহ বাংলাদেশের সকল সরকারি অনলাইন শিক্ষা সেবা এক পেজে খুঁজুন।',
                'icon' => 'fas fa-graduation-cap',
                'type' => 'free',
                'is_active' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'Health Services',
                'name_bn' => 'স্বাস্থ্য সেবা',
                'slug' => 'health-service',
                'description' => 'Government and private doctor consultations, telemedicine, lab services, and medicine delivery.',
                'description_bn' => 'সরকারি ও বেসরকারি ডাক্তার পরামর্শ, টেলিমেডিসিন, ল্যাব সেবা, ও ওষুধ ডেলিভারি সহ সকল স্বাস্থ্যসেবার তথ্য এক পেজে খুঁজুন।',
                'icon' => 'fas fa-heartbeat',
                'type' => 'free',
                'is_active' => true,
                'sort_order' => 3,
            ],
            [
                'name' => 'Banking Services',
                'name_bn' => 'ব্যাংকিং সেবা',
                'slug' => 'banking-service',
                'description' => 'Find branches, routing numbers and SWIFT codes of all banks in Bangladesh.',
                'description_bn' => 'বাংলাদেশের সকল ব্যাংকের শাখা, রাউটিং নম্বর ও সুইফট কোড খুঁজুন।',
                'icon' => 'fas fa-university',
                'type' => 'free',
                'is_active' => true,
                'sort_order' => 4,
            ],
            [
                'name' => 'Vehicle Services',
                'name_bn' => 'যানবাহন সেবা',
                'slug' => 'vehicle-service',
                'description' => 'Driving license, vehicle registration, train and bus ticket booking.',
                'description_bn' => 'ড্রাইভিং লাইসেন্স, গাড়ির নিবন্ধন, ট্রেন ও বাসের টিকিট বুকিংসহ সকল গুরুত্বপূর্ণ যানবাহন সেবা এক জায়গায়।',
                'icon' => 'fas fa-car',
                'type' => 'free',
                'is_active' => true,
                'sort_order' => 5,
            ],
            [
                'name' => 'Land Services',
                'name_bn' => 'ভূমি সেবা',
                'slug' => 'land-service',
                'description' => 'Land records, name transfer, land development tax and all land related online services.',
                'description_bn' => 'জমির খতিয়ান, নামজারি, ভূমি উন্নয়ন কর এবং অন্যান্য সকল ভূমি সংক্রান্ত অনলাইন সেবা।',
                'icon' => 'fas fa-map-marked-alt',
                'type' => 'free',
                'is_active' => true,
                'sort_order' => 6,
            ],
        ];

        foreach ($categories as $category) {
            Category::create($category);
        }

        // Create Services
        $services = [
            // Paid Services
            [
                'category_id' => 1,
                'name' => 'Meta Service',
                'name_bn' => 'Meta Service',
                'slug' => 'meta-service',
                'short_description' => 'Facebook and Instagram marketing services for your business.',
                'short_description_bn' => 'ফেসবুক ও ইনস্টাগ্রাম মার্কেটিং এর মাধ্যমে আপনার ব্যবসাকে প্রসার করুন।',
                'description' => 'Complete Meta services including Blue Tick Verification, Business Manager Setup, Ad Account Recovery, and Page Ban Solutions.',
                'description_bn' => 'Blue Tick ভেরিফিকেশন, Business Manager সেটআপ, Ad Account রিকভারি, এবং Page Ban সমাধান সহ সম্পূর্ণ Meta সেবা।',
                'icon' => 'fab fa-meta',
                'type' => 'paid',
                'price' => 5000,
                'discount_price' => 4500,
                'is_featured' => true,
                'is_popular' => true,
                'is_active' => true,
                'sort_order' => 1,
                'features' => ['Blue Tick Verification', 'Business Manager Setup', 'Ad Account Recovery', 'Page Ban Solution'],
                'features_bn' => ['ব্লু টিক ভেরিফিকেশন', 'বিজনেস ম্যানেজার সেটআপ', 'অ্যাড অ্যাকাউন্ট রিকভারি', 'পেজ ব্যান সমাধান'],
            ],
            [
                'category_id' => 1,
                'name' => 'Sonido Global Recharge',
                'name_bn' => 'Sonido Global রিচার্জ',
                'slug' => 'sonido-global-recharge',
                'short_description' => 'Quick and easy global recharge service.',
                'short_description_bn' => 'দ্রুত এবং সহজ গ্লোবাল রিচার্জ সেবা।',
                'icon' => 'fas fa-mobile-alt',
                'type' => 'paid',
                'price' => 100,
                'is_featured' => true,
                'is_popular' => true,
                'is_active' => true,
                'sort_order' => 2,
            ],
            [
                'category_id' => 1,
                'name' => 'Brilliant Connect Recharge',
                'name_bn' => 'Brilliant Connect রিচার্জ',
                'slug' => 'brilliant-connect',
                'short_description' => 'Brilliant Connect recharge service with bonus.',
                'short_description_bn' => 'বোনাস সহ Brilliant Connect রিচার্জ সেবা।',
                'icon' => 'fas fa-broadcast-tower',
                'type' => 'paid',
                'price' => 100,
                'is_featured' => true,
                'is_popular' => true,
                'is_active' => true,
                'sort_order' => 3,
            ],
            [
                'category_id' => 1,
                'name' => 'VPN/DNS Server',
                'name_bn' => 'VPN/DNS সার্ভার',
                'slug' => 'vpn-dns',
                'short_description' => 'Secure VPN and DNS service for accessing Bangladeshi services from abroad.',
                'short_description_bn' => 'বিদেশে বসে বাংলাদেশি সেবা ব্যবহারের জন্য নিরাপদ VPN এবং DNS সেবা।',
                'icon' => 'fas fa-shield-alt',
                'type' => 'paid',
                'price' => 500,
                'discount_price' => 400,
                'is_featured' => true,
                'is_popular' => true,
                'is_active' => true,
                'sort_order' => 4,
            ],
            [
                'category_id' => 1,
                'name' => 'SIM Roaming/Recharge',
                'name_bn' => 'সিম রোমিং/ রিচার্জ',
                'slug' => 'sim-roaming',
                'short_description' => 'SIM roaming and recharge services.',
                'short_description_bn' => 'সিম রোমিং এবং রিচার্জ সেবা।',
                'icon' => 'fas fa-sim-card',
                'type' => 'paid',
                'price' => 200,
                'is_featured' => true,
                'is_popular' => false,
                'is_active' => true,
                'sort_order' => 5,
            ],
            [
                'category_id' => 1,
                'name' => 'Gift Card/Subscription',
                'name_bn' => 'গিফট কার্ড/ সাবস্ক্রিপশন',
                'slug' => 'gift-card',
                'short_description' => 'Gift cards and subscriptions for various services.',
                'short_description_bn' => 'বিভিন্ন সেবার জন্য গিফট কার্ড এবং সাবস্ক্রিপশন।',
                'icon' => 'fas fa-gift',
                'type' => 'paid',
                'price' => 1000,
                'is_featured' => true,
                'is_popular' => false,
                'is_active' => true,
                'sort_order' => 6,
            ],
            // Free Services - Government
            [
                'category_id' => 1,
                'name' => 'National ID (NID)',
                'name_bn' => 'জাতীয় পরিচয়পত্র (NID)',
                'slug' => 'nid-service',
                'short_description' => 'NID application, correction, and verification.',
                'short_description_bn' => 'NID আবেদন, তথ্য সংশোধন, এবং যাচাই।',
                'icon' => 'fas fa-id-card',
                'type' => 'free',
                'is_featured' => false,
                'is_popular' => true,
                'is_active' => true,
                'sort_order' => 1,
                'external_link' => 'https://services.nidw.gov.bd/',
            ],
            [
                'category_id' => 1,
                'name' => 'Birth & Death Registration',
                'name_bn' => 'জন্ম ও মৃত্যু নিবন্ধন',
                'slug' => 'birth-death-registration',
                'short_description' => 'Birth and death registration application and verification.',
                'short_description_bn' => 'জন্ম ও মৃত্যু নিবন্ধন আবেদন এবং যাচাই।',
                'icon' => 'fas fa-baby',
                'type' => 'free',
                'is_featured' => false,
                'is_popular' => true,
                'is_active' => true,
                'sort_order' => 2,
                'external_link' => 'https://bdris.gov.bd/',
            ],
            [
                'category_id' => 1,
                'name' => 'E-Passport',
                'name_bn' => 'ই-পাসপোর্ট',
                'slug' => 'epassport-service',
                'short_description' => 'E-passport application and status tracking.',
                'short_description_bn' => 'ই-পাসপোর্ট আবেদন এবং স্ট্যাটাস ট্র্যাকিং।',
                'icon' => 'fas fa-passport',
                'type' => 'free',
                'is_featured' => false,
                'is_popular' => true,
                'is_active' => true,
                'sort_order' => 3,
                'external_link' => 'https://www.epassport.gov.bd/',
            ],
            [
                'category_id' => 1,
                'name' => 'Online GD',
                'name_bn' => 'অনলাইন জিডি',
                'slug' => 'online-gd',
                'short_description' => 'Online General Diary (GD) filing.',
                'short_description_bn' => 'অনলাইনে জেনারেল ডায়েরি (জিডি) করার সুবিধা।',
                'icon' => 'fas fa-file-alt',
                'type' => 'free',
                'is_featured' => false,
                'is_popular' => true,
                'is_active' => true,
                'sort_order' => 4,
                'external_link' => 'https://gd.police.gov.bd/',
            ],
            [
                'category_id' => 1,
                'name' => 'Court Case Information',
                'name_bn' => 'কোর্ট মামলার তথ্য',
                'slug' => 'court-case-info',
                'short_description' => 'Search court case information online.',
                'short_description_bn' => 'অনলাইনে আদালতের মামলার তথ্য অনুসন্ধান করুন।',
                'icon' => 'fas fa-gavel',
                'type' => 'free',
                'is_featured' => false,
                'is_popular' => false,
                'is_active' => true,
                'sort_order' => 5,
                'external_link' => 'https://www.supremecourt.gov.bd/',
            ],
            [
                'category_id' => 1,
                'name' => 'Social Welfare Allowance',
                'name_bn' => 'সমাজকল্যাণ ভাতা',
                'slug' => 'social-welfare-allowance',
                'short_description' => 'Apply for elderly, widow and disabled allowances.',
                'short_description_bn' => 'বয়স্ক, বিধবা ও প্রতিবন্ধী ভাতার জন্য আবেদন করুন।',
                'icon' => 'fas fa-hands-helping',
                'type' => 'free',
                'is_featured' => false,
                'is_popular' => false,
                'is_active' => true,
                'sort_order' => 6,
                'external_link' => 'https://dss.gov.bd/',
            ],
        ];

        foreach ($services as $service) {
            Service::create($service);
        }

        // Create Service Links for NID Service
        $nidLinks = [
            [
                'service_id' => 7,
                'title' => 'NID Application',
                'title_bn' => 'NID আবেদন',
                'url' => 'https://services.nidw.gov.bd/',
                'icon' => 'fas fa-edit',
                'sort_order' => 1,
            ],
            [
                'service_id' => 7,
                'title' => 'NID Correction',
                'title_bn' => 'তথ্য সংশোধন',
                'url' => 'https://services.nidw.gov.bd/nid_correction',
                'icon' => 'fas fa-edit',
                'sort_order' => 2,
            ],
            [
                'service_id' => 7,
                'title' => 'NID Verification',
                'title_bn' => 'NID যাচাই',
                'url' => 'https://services.nidw.gov.bd/voter_center',
                'icon' => 'fas fa-check-circle',
                'sort_order' => 3,
            ],
        ];

        foreach ($nidLinks as $link) {
            ServiceLink::create($link);
        }

        // Create Service Links for Birth Registration
        $birthLinks = [
            [
                'service_id' => 8,
                'title' => 'Registration Application',
                'title_bn' => 'নিবন্ধন আবেদন',
                'url' => 'https://bdris.gov.bd/br/application',
                'icon' => 'fas fa-edit',
                'sort_order' => 1,
            ],
            [
                'service_id' => 8,
                'title' => 'Information Verification',
                'title_bn' => 'তথ্য যাচাই',
                'url' => 'https://everify.bdris.gov.bd/',
                'icon' => 'fas fa-check-circle',
                'sort_order' => 2,
            ],
            [
                'service_id' => 8,
                'title' => 'Certificate Download',
                'title_bn' => 'সনদ ডাউনলোড',
                'url' => 'https://bdris.gov.bd/br/certificate',
                'icon' => 'fas fa-download',
                'sort_order' => 3,
            ],
        ];

        foreach ($birthLinks as $link) {
            ServiceLink::create($link);
        }

        // Create Service Links for E-Passport
        $passportLinks = [
            [
                'service_id' => 9,
                'title' => 'Application',
                'title_bn' => 'আবেদন',
                'url' => 'https://www.epassport.gov.bd/',
                'icon' => 'fas fa-edit',
                'sort_order' => 1,
            ],
            [
                'service_id' => 9,
                'title' => 'Status Check',
                'title_bn' => 'স্ট্যাটাস',
                'url' => 'https://www.epassport.gov.bd/authorization/status',
                'icon' => 'fas fa-search',
                'sort_order' => 2,
            ],
            [
                'service_id' => 9,
                'title' => 'Guidelines',
                'title_bn' => 'নির্দেশিকা',
                'url' => 'https://www.epassport.gov.bd/instruction',
                'icon' => 'fas fa-info-circle',
                'sort_order' => 3,
            ],
        ];

        foreach ($passportLinks as $link) {
            ServiceLink::create($link);
        }
    }
}
