#!/bin/bash

# Mamun eService Deployment Script
# This script helps deploy the Laravel application to cPanel

echo "=================================="
echo "Mamun eService Deployment Script"
echo "=================================="
echo ""

# Colors
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

# Check if composer is installed
if ! command -v composer &> /dev/null
then
    echo -e "${RED}Composer not found! Please install Composer first.${NC}"
    exit 1
fi

echo -e "${YELLOW}Step 1: Installing dependencies...${NC}"
composer install --no-dev --optimize-autoloader

echo ""
echo -e "${YELLOW}Step 2: Setting up environment...${NC}"
if [ ! -f .env ]; then
    cp .env.example .env
    echo -e "${GREEN}.env file created from .env.example${NC}"
    echo -e "${RED}Please update .env file with your database credentials!${NC}"
else
    echo -e "${GREEN}.env file already exists${NC}"
fi

echo ""
echo -e "${YELLOW}Step 3: Generating application key...${NC}"
php artisan key:generate

echo ""
echo -e "${YELLOW}Step 4: Running database migrations...${NC}"
php artisan migrate --force

echo ""
echo -e "${YELLOW}Step 5: Seeding database...${NC}"
php artisan db:seed --force

echo ""
echo -e "${YELLOW}Step 6: Creating storage link...${NC}"
php artisan storage:link

echo ""
echo -e "${YELLOW}Step 7: Caching configuration...${NC}"
php artisan config:cache
php artisan route:cache
php artisan view:cache

echo ""
echo -e "${YELLOW}Step 8: Setting permissions...${NC}"
chmod -R 775 storage bootstrap/cache

echo ""
echo "=================================="
echo -e "${GREEN}Deployment completed!${NC}"
echo "=================================="
echo ""
echo "Default Admin Credentials:"
echo "Email: admin@mamuneservice.com"
echo "Password: admin123"
echo ""
echo -e "${RED}IMPORTANT: Please change the default password after first login!${NC}"
echo ""
echo "Next steps:"
echo "1. Update .env file with your database credentials"
echo "2. Update .env file with your APP_URL"
echo "3. Login to admin panel and change default password"
echo "4. Configure your services and categories"
