@extends('layouts.app')

@section('title', 'অর্ডার ট্র্যাক')

@section('content')
<!-- Page Header -->
<section class="py-20 bg-dark-light/50 relative overflow-hidden">
    <div class="absolute inset-0">
        <div class="absolute top-0 left-0 w-96 h-96 bg-primary/10 rounded-full filter blur-3xl"></div>
    </div>
    
    <div class="container mx-auto px-4 relative z-10">
        <div class="text-center max-w-2xl mx-auto">
            <span class="inline-block bg-primary/20 text-primary px-4 py-2 rounded-full text-sm font-medium mb-4">
                অর্ডার ট্র্যাক
            </span>
            <h1 class="text-3xl md:text-5xl font-bold mb-4">আপনার অর্ডার ট্র্যাক করুন</h1>
            <p class="text-gray-400">
                অর্ডার নম্বর দিয়ে আপনার অর্ডারের স্ট্যাটাস দেখুন
            </p>
        </div>
        
        <!-- Search Form -->
        <div class="max-w-xl mx-auto mt-8">
            <form action="{{ route('orders.track') }}" method="GET" class="relative">
                <input 
                    type="text" 
                    name="order_number" 
                    value="{{ $orderNumber ?? '' }}"
                    placeholder="অর্ডার নম্বর লিখুন... (যেমন: ORD-XXXXXX)" 
                    class="w-full bg-dark border border-white/10 rounded-xl px-5 py-4 pl-12 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors"
                >
                <i class="fas fa-search absolute left-4 top-1/2 -translate-y-1/2 text-gray-500"></i>
                <button type="submit" class="absolute right-2 top-1/2 -translate-y-1/2 bg-primary hover:bg-primary/80 text-white px-6 py-2 rounded-lg transition-colors">
                    খুঁজুন
                </button>
            </form>
        </div>
    </div>
</section>

<!-- Order Result -->
@if($order)
<section class="py-20 bg-dark">
    <div class="container mx-auto px-4">
        <div class="max-w-2xl mx-auto">
            <div class="bg-dark-light rounded-2xl p-6 md:p-8 border border-white/10">
                <div class="text-center mb-8">
                    <h2 class="text-2xl font-bold mb-2">অর্ডার পাওয়া গেছে</h2>
                    <p class="text-gray-400 font-mono">{{ $order->order_number }}</p>
                </div>
                
                <!-- Status Timeline -->
                <div class="relative">
                    <div class="absolute left-4 top-0 bottom-0 w-0.5 bg-white/10"></div>
                    
                    <div class="space-y-8">
                        <!-- Order Placed -->
                        <div class="relative flex items-start gap-4">
                            <div class="w-8 h-8 bg-green-500 rounded-full flex items-center justify-center flex-shrink-0 relative z-10">
                                <i class="fas fa-check text-white text-sm"></i>
                            </div>
                            <div>
                                <h3 class="font-bold">অর্ডার প্লেসড</h3>
                                <p class="text-gray-400 text-sm">{{ $order->created_at->format('d M, Y h:i A') }}</p>
                            </div>
                        </div>
                        
                        <!-- Processing -->
                        <div class="relative flex items-start gap-4">
                            <div class="w-8 h-8 {{ in_array($order->status, ['processing', 'completed']) ? 'bg-green-500' : 'bg-white/10' }} rounded-full flex items-center justify-center flex-shrink-0 relative z-10">
                                @if(in_array($order->status, ['processing', 'completed']))
                                    <i class="fas fa-check text-white text-sm"></i>
                                @else
                                    <i class="fas fa-clock text-gray-400 text-sm"></i>
                                @endif
                            </div>
                            <div>
                                <h3 class="font-bold {{ in_array($order->status, ['processing', 'completed']) ? '' : 'text-gray-500' }}">প্রক্রিয়াধীন</h3>
                                <p class="text-gray-400 text-sm">আপনার অর্ডার প্রক্রিয়াধীন</p>
                            </div>
                        </div>
                        
                        <!-- Completed -->
                        <div class="relative flex items-start gap-4">
                            <div class="w-8 h-8 {{ $order->status == 'completed' ? 'bg-green-500' : 'bg-white/10' }} rounded-full flex items-center justify-center flex-shrink-0 relative z-10">
                                @if($order->status == 'completed')
                                    <i class="fas fa-check text-white text-sm"></i>
                                @else
                                    <i class="fas fa-flag-checkered text-gray-400 text-sm"></i>
                                @endif
                            </div>
                            <div>
                                <h3 class="font-bold {{ $order->status == 'completed' ? '' : 'text-gray-500' }}">সম্পন্ন</h3>
                                <p class="text-gray-400 text-sm">
                                    @if($order->status == 'completed')
                                        আপনার অর্ডার সম্পন্ন হয়েছে
                                    @else
                                        অপেক্ষমাণ
                                    @endif
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Order Details -->
                <div class="mt-10 pt-8 border-t border-white/10">
                    <h3 class="font-bold mb-4">অর্ডার বিস্তারিত</h3>
                    <div class="grid md:grid-cols-2 gap-4">
                        <div>
                            <p class="text-gray-400 text-sm mb-1">সেবা</p>
                            <p class="font-medium">{{ $order->service->name_bn ?? 'N/A' }}</p>
                        </div>
                        <div>
                            <p class="text-gray-400 text-sm mb-1">গ্রাহক</p>
                            <p class="font-medium">{{ $order->customer_name }}</p>
                        </div>
                        <div>
                            <p class="text-gray-400 text-sm mb-1">ফোন</p>
                            <p class="font-medium">{{ $order->customer_phone }}</p>
                        </div>
                        <div>
                            <p class="text-gray-400 text-sm mb-1">পেমেন্ট স্ট্যাটাস</p>
                            <p class="font-medium">
                                @switch($order->payment_status)
                                    @case('pending')
                                        <span class="text-yellow-400">অপেক্ষমাণ</span>
                                        @break
                                    @case('paid')
                                        <span class="text-green-400">পরিশোধিত</span>
                                        @break
                                    @case('failed')
                                        <span class="text-red-400">ব্যর্থ</span>
                                        @break
                                    @case('refunded')
                                        <span class="text-gray-400">রিফান্ড</span>
                                        @break
                                @endswitch
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@elseif($orderNumber)
<section class="py-20 bg-dark">
    <div class="container mx-auto px-4">
        <div class="max-w-2xl mx-auto text-center">
            <div class="bg-dark-light rounded-2xl p-8 border border-white/10">
                <div class="w-20 h-20 bg-red-500/20 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-times text-red-400 text-3xl"></i>
                </div>
                <h2 class="text-2xl font-bold mb-2">অর্ডার পাওয়া যায়নি</h2>
                <p class="text-gray-400 mb-6">
                    "{{ $orderNumber }}" নম্বরে কোনো অর্ডার পাওয়া যায়নি। দয়া করে সঠিক অর্ডার নম্বর দিন।
                </p>
                <a href="{{ route('orders.track') }}" class="inline-flex items-center gap-2 bg-primary hover:bg-primary/80 text-white px-6 py-3 rounded-xl transition-colors">
                    <i class="fas fa-arrow-left"></i>
                    আবার চেষ্টা করুন
                </a>
            </div>
        </div>
    </div>
</section>
@endif
@endsection
