<?php

namespace App\Http\Controllers;

use App\Models\Order;
use App\Models\Service;
use Illuminate\Http\Request;

class OrderController extends Controller
{
    public function store(Request $request)
    {
        $validated = $request->validate([
            'service_id' => 'required|exists:services,id',
            'customer_name' => 'required|string|max:255',
            'customer_phone' => 'required|string|max:20',
            'customer_email' => 'nullable|email|max:255',
            'details' => 'nullable|string',
            'id_link' => 'nullable|string|max:500',
            'platform' => 'nullable|string|max:50',
            'service_type' => 'nullable|string|max:50',
            'priority' => 'nullable|string|max:20',
            'document' => 'nullable|file|max:5120',
        ]);

        $service = Service::findOrFail($validated['service_id']);

        if ($request->hasFile('document')) {
            $validated['document'] = $request->file('document')->store('documents', 'public');
        }

        $validated['amount'] = $service->discount_price ?? $service->price;
        $validated['status'] = 'pending';
        $validated['payment_status'] = 'pending';

        $order = Order::create($validated);

        return redirect()->back()->with('success', 'আপনার অর্ডার সফলভাবে গ্রহণ করা হয়েছে! অর্ডার নম্বর: ' . $order->order_number);
    }

    public function track(Request $request)
    {
        $orderNumber = $request->get('order_number');
        $order = null;

        if ($orderNumber) {
            $order = Order::with('service')
                ->where('order_number', $orderNumber)
                ->first();
        }

        return view('orders.track', compact('order', 'orderNumber'));
    }
}
