<!-- Top Announcement Bar -->
<div class="bg-gradient-to-r from-primary via-secondary to-accent text-white py-2 px-4 text-center text-sm">
    <div class="container mx-auto flex items-center justify-center gap-2">
        <i class="fas fa-gift animate-bounce"></i>
        <span>সব রিচার্জে ১২% বোনাস সীমিত সময়ের জন্য</span>
    </div>
</div>

<!-- Main Header -->
<header class="bg-dark-light/95 backdrop-blur-md sticky top-0 z-40 border-b border-white/10">
    <div class="container mx-auto px-4">
        <div class="flex items-center justify-between h-16">
            <!-- Logo -->
            <a href="{{ route('home') }}" class="flex items-center gap-2">
                <div class="w-10 h-10 bg-gradient-to-br from-primary to-secondary rounded-lg flex items-center justify-center">
                    <span class="text-white font-bold text-xl">M</span>
                </div>
                <div class="hidden sm:block">
                    <h1 class="text-lg font-bold leading-tight">Mamun eService</h1>
                    <p class="text-xs text-gray-400">আপনার বিশ্বস্ত ডিজিটাল সহযোগী</p>
                </div>
            </a>
            
            <!-- Desktop Navigation -->
            <nav class="hidden lg:flex items-center gap-6">
                <a href="{{ route('home') }}" class="nav-link {{ request()->routeIs('home') ? 'text-primary' : 'text-gray-300 hover:text-white' }} transition-colors">
                    হোম
                </a>
                <a href="{{ route('home') }}#services" class="nav-link text-gray-300 hover:text-white transition-colors">
                    সেবাসমূহ
                </a>
                <a href="{{ route('services.index') }}" class="nav-link {{ request()->routeIs('services.*') ? 'text-primary' : 'text-gray-300 hover:text-white' }} transition-colors">
                    সরকারি সেবা
                </a>
                <a href="{{ route('about') }}" class="nav-link {{ request()->routeIs('about') ? 'text-primary' : 'text-gray-300 hover:text-white' }} transition-colors">
                    আমাদের সম্পর্কে
                </a>
                <a href="{{ route('contact') }}" class="nav-link {{ request()->routeIs('contact') ? 'text-primary' : 'text-gray-300 hover:text-white' }} transition-colors">
                    যোগাযোগ
                </a>
            </nav>
            
            <!-- Right Actions -->
            <div class="flex items-center gap-3">
                @auth
                    <a href="{{ route('admin.dashboard') }}" class="hidden sm:flex items-center gap-2 bg-primary hover:bg-primary/80 text-white px-4 py-2 rounded-lg transition-colors">
                        <i class="fas fa-tachometer-alt"></i>
                        <span>ড্যাশবোর্ড</span>
                    </a>
                    <form action="{{ route('logout') }}" method="POST" class="hidden sm:block">
                        @csrf
                        <button type="submit" class="flex items-center gap-2 bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded-lg transition-colors">
                            <i class="fas fa-sign-out-alt"></i>
                            <span>লগআউট</span>
                        </button>
                    </form>
                @else
                    <a href="{{ route('login') }}" class="hidden sm:flex items-center gap-2 bg-primary hover:bg-primary/80 text-white px-4 py-2 rounded-lg transition-colors">
                        <i class="fas fa-user"></i>
                        <span>লগইন</span>
                    </a>
                @endauth
                
                <!-- Mobile Menu Button -->
                <button id="mobileMenuBtn" class="lg:hidden p-2 text-white hover:bg-white/10 rounded-lg transition-colors">
                    <i class="fas fa-bars text-xl"></i>
                </button>
            </div>
        </div>
    </div>
    
    <!-- Mobile Navigation -->
    <div id="mobileMenu" class="lg:hidden hidden bg-dark-light border-t border-white/10">
        <div class="container mx-auto px-4 py-4 space-y-2">
            <a href="{{ route('home') }}" class="block py-2 px-4 rounded-lg {{ request()->routeIs('home') ? 'bg-primary/20 text-primary' : 'text-gray-300 hover:bg-white/5' }}">
                <i class="fas fa-home w-6"></i> হোম
            </a>
            <a href="{{ route('home') }}#services" class="block py-2 px-4 rounded-lg text-gray-300 hover:bg-white/5">
                <i class="fas fa-cogs w-6"></i> সেবাসমূহ
            </a>
            <a href="{{ route('services.index') }}" class="block py-2 px-4 rounded-lg {{ request()->routeIs('services.*') ? 'bg-primary/20 text-primary' : 'text-gray-300 hover:bg-white/5' }}">
                <i class="fas fa-landmark w-6"></i> সরকারি সেবা
            </a>
            <a href="{{ route('about') }}" class="block py-2 px-4 rounded-lg {{ request()->routeIs('about') ? 'bg-primary/20 text-primary' : 'text-gray-300 hover:bg-white/5' }}">
                <i class="fas fa-info-circle w-6"></i> আমাদের সম্পর্কে
            </a>
            <a href="{{ route('contact') }}" class="block py-2 px-4 rounded-lg {{ request()->routeIs('contact') ? 'bg-primary/20 text-primary' : 'text-gray-300 hover:bg-white/5' }}">
                <i class="fas fa-envelope w-6"></i> যোগাযোগ
            </a>
            @auth
                <a href="{{ route('admin.dashboard') }}" class="block py-2 px-4 rounded-lg text-primary hover:bg-white/5">
                    <i class="fas fa-tachometer-alt w-6"></i> ড্যাশবোর্ড
                </a>
                <form action="{{ route('logout') }}" method="POST">
                    @csrf
                    <button type="submit" class="w-full text-left py-2 px-4 rounded-lg text-red-400 hover:bg-white/5">
                        <i class="fas fa-sign-out-alt w-6"></i> লগআউট
                    </button>
                </form>
            @else
                <a href="{{ route('login') }}" class="block py-2 px-4 rounded-lg text-primary hover:bg-white/5">
                    <i class="fas fa-user w-6"></i> লগইন
                </a>
            @endauth
        </div>
    </div>
</header>
