@extends('layouts.app')

@section('title', 'আমাদের সম্পর্কে')

@section('content')
<!-- Page Header -->
<section class="py-20 bg-dark-light/50 relative overflow-hidden">
    <div class="absolute inset-0">
        <div class="absolute top-0 left-0 w-96 h-96 bg-primary/10 rounded-full filter blur-3xl"></div>
    </div>
    
    <div class="container mx-auto px-4 relative z-10">
        <div class="text-center max-w-2xl mx-auto">
            <span class="inline-block bg-primary/20 text-primary px-4 py-2 rounded-full text-sm font-medium mb-4">
                আমাদের সম্পর্কে
            </span>
            <h1 class="text-3xl md:text-5xl font-bold mb-4">Mamun eService</h1>
            <p class="text-gray-400">
                বাংলাদেশের সেরা ডিজিটাল সেবা প্রদানকারী
            </p>
        </div>
    </div>
</section>

<!-- About Content -->
<section class="py-20 bg-dark">
    <div class="container mx-auto px-4">
        <div class="grid lg:grid-cols-2 gap-12 items-center">
            <div>
                <h2 class="text-2xl md:text-3xl font-bold mb-6">আমরা কে?</h2>
                <p class="text-gray-400 mb-4">
                    Mamun eService বাংলাদেশের একটি বিশ্বস্ত ডিজিটাল সেবা প্রদানকারী প্রতিষ্ঠান। আমরা ২০২০ সাল থেকে আমাদের গ্রাহকদের সেরা মানের সেবা প্রদানের জন্য কাজ করছি।
                </p>
                <p class="text-gray-400 mb-4">
                    আমাদের লক্ষ্য হলো বাংলাদেশের সকল মানুষের কাছে ডিজিটাল সেবা পৌঁছে দেওয়া। আমরা বিশ্বাস করি যে প্রযুক্তির মাধ্যমে জীবনকে আরও সহজ করা সম্ভব।
                </p>
                <p class="text-gray-400">
                    আমাদের দক্ষ টিম সর্বদা আপনাদের সেবায় নিয়োজিত। যেকোনো সমস্যায় আমাদের সাথে যোগাযোগ করুন।
                </p>
            </div>
            <div class="flex justify-center">
                <div class="relative">
                    <div class="w-80 h-80 bg-gradient-to-br from-primary/20 to-secondary/20 rounded-full filter blur-3xl absolute -inset-8"></div>
                    <div class="relative w-72 h-72 bg-dark-light rounded-3xl border border-white/10 flex items-center justify-center">
                        <div class="text-center">
                            <div class="w-24 h-24 bg-gradient-to-br from-primary to-secondary rounded-2xl mx-auto mb-4 flex items-center justify-center">
                                <span class="text-white font-bold text-4xl">M</span>
                            </div>
                            <h3 class="text-2xl font-bold">Mamun eService</h3>
                            <p class="text-gray-400">বিশ্বস্ত ডিজিটাল সহযোগী</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Stats Section -->
<section class="py-20 bg-dark-light/50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-12">
            <h2 class="text-2xl md:text-3xl font-bold mb-4">আমাদের পরিসংখ্যান</h2>
            <p class="text-gray-400">আমাদের কাজের সাক্ষ্য</p>
        </div>
        
        <div class="grid grid-cols-2 lg:grid-cols-4 gap-6">
            <div class="bg-dark rounded-2xl p-6 text-center border border-white/10">
                <div class="text-3xl md:text-4xl font-bold text-primary mb-2">{{ $stats['customers'] }}+</div>
                <p class="text-gray-400">সন্তুষ্ট গ্রাহক</p>
            </div>
            <div class="bg-dark rounded-2xl p-6 text-center border border-white/10">
                <div class="text-3xl md:text-4xl font-bold text-secondary mb-2">{{ $stats['success'] }}+</div>
                <p class="text-gray-400">সফল সেবা</p>
            </div>
            <div class="bg-dark rounded-2xl p-6 text-center border border-white/10">
                <div class="text-3xl md:text-4xl font-bold text-accent mb-2">{{ $stats['satisfaction'] }}%</div>
                <p class="text-gray-400">সন্তুষ্টির হার</p>
            </div>
            <div class="bg-dark rounded-2xl p-6 text-center border border-white/10">
                <div class="text-3xl md:text-4xl font-bold text-green-400 mb-2">{{ $stats['support'] }}</div>
                <p class="text-gray-400">সাপোর্ট</p>
            </div>
        </div>
    </div>
</section>

<!-- Mission & Vision -->
<section class="py-20 bg-dark">
    <div class="container mx-auto px-4">
        <div class="grid md:grid-cols-2 gap-8">
            <div class="bg-dark-light rounded-2xl p-8 border border-white/10">
                <div class="w-14 h-14 bg-primary/20 rounded-xl flex items-center justify-center mb-6">
                    <i class="fas fa-bullseye text-primary text-2xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">আমাদের লক্ষ্য</h3>
                <p class="text-gray-400">
                    বাংলাদেশের সকল মানুষের কাছে ডিজিটাল সেবা পৌঁছে দেওয়া এবং তাদের জীবনকে আরও সহজ করা। আমরা সর্বদা আমাদের গ্রাহকদের সেরা মানের সেবা প্রদানের চেষ্টা করি।
                </p>
            </div>
            <div class="bg-dark-light rounded-2xl p-8 border border-white/10">
                <div class="w-14 h-14 bg-secondary/20 rounded-xl flex items-center justify-center mb-6">
                    <i class="fas fa-eye text-secondary text-2xl"></i>
                </div>
                <h3 class="text-xl font-bold mb-4">আমাদের দৃষ্টিভঙ্গি</h3>
                <p class="text-gray-400">
                    বাংলাদেশের সেরা ডিজিটাল সেবা প্রদানকারী প্রতিষ্ঠান হওয়া। আমরা বিশ্বাস করি যে প্রযুক্তির মাধ্যমে একটি উন্নত সমাজ গড়া সম্ভব।
                </p>
            </div>
        </div>
    </div>
</section>

<!-- Contact CTA -->
<section class="py-20 bg-gradient-to-br from-primary/10 via-secondary/10 to-accent/10">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-2xl md:text-3xl font-bold mb-4">যোগাযোগ করুন</h2>
        <p class="text-gray-400 max-w-2xl mx-auto mb-8">
            যেকোনো প্রয়োজনে আমাদের সাথে যোগাযোগ করুন। আমরা সর্বদা আপনাদের সেবায় প্রস্তুত।
        </p>
        <a href="{{ route('contact') }}" class="inline-flex items-center gap-2 bg-gradient-to-r from-primary to-secondary hover:from-primary/80 hover:to-secondary/80 text-white px-8 py-4 rounded-xl font-semibold transition-all duration-300">
            <i class="fas fa-envelope"></i>
            যোগাযোগ করুন
        </a>
    </div>
</section>
@endsection
