@extends('layouts.app')

@section('title', 'Admin Dashboard')

@section('content')
<!-- Admin Header -->
<section class="py-10 bg-dark-light/50 border-b border-white/10">
    <div class="container mx-auto px-4">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
            <div>
                <h1 class="text-2xl md:text-3xl font-bold">ড্যাশবোর্ড</h1>
                <p class="text-gray-400">স্বাগতম, {{ auth()->user()->name }}</p>
            </div>
            <div class="flex gap-3">
                <a href="{{ route('admin.orders') }}?status=pending" class="bg-yellow-500/20 text-yellow-400 px-4 py-2 rounded-lg text-sm">
                    <i class="fas fa-clock mr-2"></i>{{ $stats['pending_orders'] }} অপেক্ষমাণ
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Stats Cards -->
<section class="py-10 bg-dark">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-2 lg:grid-cols-3 gap-4 md:gap-6">
            <div class="bg-dark-light rounded-2xl p-6 border border-white/10">
                <div class="flex items-center justify-between mb-4">
                    <div class="w-12 h-12 bg-primary/20 rounded-xl flex items-center justify-center">
                        <i class="fas fa-shopping-cart text-primary text-xl"></i>
                    </div>
                    <span class="text-green-400 text-sm"><i class="fas fa-arrow-up mr-1"></i>মোট</span>
                </div>
                <h3 class="text-3xl font-bold">{{ $stats['total_orders'] }}</h3>
                <p class="text-gray-400 text-sm">মোট অর্ডার</p>
            </div>
            
            <div class="bg-dark-light rounded-2xl p-6 border border-white/10">
                <div class="flex items-center justify-between mb-4">
                    <div class="w-12 h-12 bg-yellow-500/20 rounded-xl flex items-center justify-center">
                        <i class="fas fa-clock text-yellow-400 text-xl"></i>
                    </div>
                    <span class="text-yellow-400 text-sm">অপেক্ষমাণ</span>
                </div>
                <h3 class="text-3xl font-bold">{{ $stats['pending_orders'] }}</h3>
                <p class="text-gray-400 text-sm">অপেক্ষমাণ অর্ডার</p>
            </div>
            
            <div class="bg-dark-light rounded-2xl p-6 border border-white/10">
                <div class="flex items-center justify-between mb-4">
                    <div class="w-12 h-12 bg-green-500/20 rounded-xl flex items-center justify-center">
                        <i class="fas fa-check-circle text-green-400 text-xl"></i>
                    </div>
                    <span class="text-green-400 text-sm">সম্পন্ন</span>
                </div>
                <h3 class="text-3xl font-bold">{{ $stats['completed_orders'] }}</h3>
                <p class="text-gray-400 text-sm">সম্পন্ন অর্ডার</p>
            </div>
            
            <div class="bg-dark-light rounded-2xl p-6 border border-white/10">
                <div class="flex items-center justify-between mb-4">
                    <div class="w-12 h-12 bg-secondary/20 rounded-xl flex items-center justify-center">
                        <i class="fas fa-cogs text-secondary text-xl"></i>
                    </div>
                    <span class="text-secondary text-sm">সেবা</span>
                </div>
                <h3 class="text-3xl font-bold">{{ $stats['total_services'] }}</h3>
                <p class="text-gray-400 text-sm">মোট সেবা</p>
            </div>
            
            <div class="bg-dark-light rounded-2xl p-6 border border-white/10">
                <div class="flex items-center justify-between mb-4">
                    <div class="w-12 h-12 bg-accent/20 rounded-xl flex items-center justify-center">
                        <i class="fas fa-folder text-accent text-xl"></i>
                    </div>
                    <span class="text-accent text-sm">ক্যাটাগরি</span>
                </div>
                <h3 class="text-3xl font-bold">{{ $stats['total_categories'] }}</h3>
                <p class="text-gray-400 text-sm">মোট ক্যাটাগরি</p>
            </div>
            
            <div class="bg-dark-light rounded-2xl p-6 border border-white/10">
                <div class="flex items-center justify-between mb-4">
                    <div class="w-12 h-12 bg-blue-500/20 rounded-xl flex items-center justify-center">
                        <i class="fas fa-users text-blue-400 text-xl"></i>
                    </div>
                    <span class="text-blue-400 text-sm">ইউজার</span>
                </div>
                <h3 class="text-3xl font-bold">{{ $stats['total_users'] }}</h3>
                <p class="text-gray-400 text-sm">মোট ইউজার</p>
            </div>
        </div>
    </div>
</section>

<!-- Quick Actions -->
<section class="py-10 bg-dark-light/50">
    <div class="container mx-auto px-4">
        <h2 class="text-xl font-bold mb-6">দ্রুত কার্যক্রম</h2>
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
            <a href="{{ route('admin.services.create') }}" class="bg-dark rounded-2xl p-6 border border-white/10 hover:border-primary/50 transition-all text-center group">
                <div class="w-14 h-14 bg-primary/20 rounded-xl flex items-center justify-center mx-auto mb-3 group-hover:bg-primary/30 transition-colors">
                    <i class="fas fa-plus text-primary text-xl"></i>
                </div>
                <span class="font-medium">নতুন সেবা</span>
            </a>
            
            <a href="{{ route('admin.categories.create') }}" class="bg-dark rounded-2xl p-6 border border-white/10 hover:border-secondary/50 transition-all text-center group">
                <div class="w-14 h-14 bg-secondary/20 rounded-xl flex items-center justify-center mx-auto mb-3 group-hover:bg-secondary/30 transition-colors">
                    <i class="fas fa-folder-plus text-secondary text-xl"></i>
                </div>
                <span class="font-medium">নতুন ক্যাটাগরি</span>
            </a>
            
            <a href="{{ route('admin.orders') }}" class="bg-dark rounded-2xl p-6 border border-white/10 hover:border-yellow-500/50 transition-all text-center group">
                <div class="w-14 h-14 bg-yellow-500/20 rounded-xl flex items-center justify-center mx-auto mb-3 group-hover:bg-yellow-500/30 transition-colors">
                    <i class="fas fa-list text-yellow-400 text-xl"></i>
                </div>
                <span class="font-medium">অর্ডার লিস্ট</span>
            </a>
            
            <a href="{{ route('admin.users') }}" class="bg-dark rounded-2xl p-6 border border-white/10 hover:border-blue-500/50 transition-all text-center group">
                <div class="w-14 h-14 bg-blue-500/20 rounded-xl flex items-center justify-center mx-auto mb-3 group-hover:bg-blue-500/30 transition-colors">
                    <i class="fas fa-user-plus text-blue-400 text-xl"></i>
                </div>
                <span class="font-medium">নতুন ইউজার</span>
            </a>
        </div>
    </div>
</section>

<!-- Recent Orders -->
<section class="py-10 bg-dark">
    <div class="container mx-auto px-4">
        <div class="flex items-center justify-between mb-6">
            <h2 class="text-xl font-bold">সাম্প্রতিক অর্ডার</h2>
            <a href="{{ route('admin.orders') }}" class="text-primary hover:text-primary/80 text-sm">
                সব দেখুন <i class="fas fa-arrow-right ml-1"></i>
            </a>
        </div>
        
        <div class="bg-dark-light rounded-2xl border border-white/10 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-white/5">
                        <tr>
                            <th class="text-left px-6 py-4 text-sm font-medium text-gray-400">অর্ডার নং</th>
                            <th class="text-left px-6 py-4 text-sm font-medium text-gray-400">সেবা</th>
                            <th class="text-left px-6 py-4 text-sm font-medium text-gray-400">গ্রাহক</th>
                            <th class="text-left px-6 py-4 text-sm font-medium text-gray-400">স্ট্যাটাস</th>
                            <th class="text-left px-6 py-4 text-sm font-medium text-gray-400">তারিখ</th>
                            <th class="text-left px-6 py-4 text-sm font-medium text-gray-400">অ্যাকশন</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-white/5">
                        @forelse($recentOrders as $order)
                        <tr class="hover:bg-white/5 transition-colors">
                            <td class="px-6 py-4">
                                <span class="font-mono text-sm">{{ $order->order_number }}</span>
                            </td>
                            <td class="px-6 py-4">
                                <span class="text-sm">{{ $order->service->name_bn ?? 'N/A' }}</span>
                            </td>
                            <td class="px-6 py-4">
                                <div>
                                    <div class="text-sm font-medium">{{ $order->customer_name }}</div>
                                    <div class="text-xs text-gray-500">{{ $order->customer_phone }}</div>
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                @switch($order->status)
                                    @case('pending')
                                        <span class="inline-flex items-center gap-1 bg-yellow-500/20 text-yellow-400 px-3 py-1 rounded-full text-xs">
                                            <i class="fas fa-clock"></i> অপেক্ষমাণ
                                        </span>
                                        @break
                                    @case('processing')
                                        <span class="inline-flex items-center gap-1 bg-blue-500/20 text-blue-400 px-3 py-1 rounded-full text-xs">
                                            <i class="fas fa-spinner fa-spin"></i> প্রক্রিয়াধীন
                                        </span>
                                        @break
                                    @case('completed')
                                        <span class="inline-flex items-center gap-1 bg-green-500/20 text-green-400 px-3 py-1 rounded-full text-xs">
                                            <i class="fas fa-check-circle"></i> সম্পন্ন
                                        </span>
                                        @break
                                    @case('cancelled')
                                        <span class="inline-flex items-center gap-1 bg-red-500/20 text-red-400 px-3 py-1 rounded-full text-xs">
                                            <i class="fas fa-times-circle"></i> বাতিল
                                        </span>
                                        @break
                                @endswitch
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-400">
                                {{ $order->created_at->format('d M, Y') }}
                            </td>
                            <td class="px-6 py-4">
                                <a href="{{ route('admin.orders.show', $order) }}" class="text-primary hover:text-primary/80 text-sm">
                                    <i class="fas fa-eye"></i> দেখুন
                                </a>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="6" class="px-6 py-8 text-center text-gray-400">
                                <i class="fas fa-inbox text-4xl mb-3"></i>
                                <p>কোনো অর্ডার পাওয়া যায়নি</p>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</section>
@endsection
