@extends('layouts.app')

@section('title', 'নতুন ইউজার')

@section('content')
<section class="py-10 bg-dark-light/50 border-b border-white/10">
    <div class="container mx-auto px-4">
        <div class="flex items-center gap-2 text-sm text-gray-400 mb-4">
            <a href="{{ route('admin.dashboard') }}" class="hover:text-white transition-colors">ড্যাশবোর্ড</a>
            <i class="fas fa-chevron-right text-xs"></i>
            <a href="{{ route('admin.users') }}" class="hover:text-white transition-colors">ইউজারসমূহ</a>
            <i class="fas fa-chevron-right text-xs"></i>
            <span>নতুন ইউজার</span>
        </div>
        <h1 class="text-2xl md:text-3xl font-bold">নতুন ইউজার যোগ করুন</h1>
    </div>
</section>

<section class="py-10 bg-dark">
    <div class="container mx-auto px-4">
        <div class="max-w-3xl mx-auto">
            <div class="bg-dark-light rounded-2xl p-6 md:p-8 border border-white/10">
                <form action="{{ route('admin.users.store') }}" method="POST">
                    @csrf
                    
                    <div class="space-y-6">
                        <div>
                            <label class="block text-sm font-medium mb-2">নাম <span class="text-red-500">*</span></label>
                            <input type="text" name="name" required class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="পূর্ণ নাম">
                            @error('name')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium mb-2">ইমেইল <span class="text-red-500">*</span></label>
                            <input type="email" name="email" required class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="email@example.com">
                            @error('email')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium mb-2">ফোন</label>
                            <input type="tel" name="phone" class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="০১XXXXXXXXX">
                            @error('phone')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium mb-2">পাসওয়ার্ড <span class="text-red-500">*</span></label>
                            <input type="password" name="password" required class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="ন্যূনতম ৮ অক্ষর">
                            @error('password')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium mb-2">রোল <span class="text-red-500">*</span></label>
                            <select name="role" required class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white focus:outline-none focus:border-primary transition-colors">
                                <option value="user">ইউজার</option>
                                <option value="admin">অ্যাডমিন</option>
                            </select>
                            @error('role')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div class="flex gap-4">
                            <button type="submit" class="flex-1 bg-gradient-to-r from-primary to-secondary hover:from-primary/80 hover:to-secondary/80 text-white py-4 rounded-xl font-semibold transition-all duration-300">
                                ইউজার যোগ করুন
                            </button>
                            <a href="{{ route('admin.users') }}" class="px-8 py-4 bg-white/10 hover:bg-white/20 text-white rounded-xl transition-colors">
                                বাতিল
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>
@endsection
