@extends('layouts.app')

@section('title', 'ইউজারসমূহ')

@section('content')
<section class="py-10 bg-dark-light/50 border-b border-white/10">
    <div class="container mx-auto px-4">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
            <div>
                <h1 class="text-2xl md:text-3xl font-bold">ইউজারসমূহ</h1>
                <p class="text-gray-400">সকল ইউজার পরিচালনা করুন</p>
            </div>
            <a href="{{ route('admin.users.create') }}" class="bg-gradient-to-r from-primary to-secondary hover:from-primary/80 hover:to-secondary/80 text-white px-6 py-3 rounded-xl transition-colors flex items-center gap-2">
                <i class="fas fa-plus"></i>
                নতুন ইউজার
            </a>
        </div>
    </div>
</section>

<section class="py-10 bg-dark">
    <div class="container mx-auto px-4">
        <div class="bg-dark-light rounded-2xl border border-white/10 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-white/5">
                        <tr>
                            <th class="text-left px-6 py-4 text-sm font-medium text-gray-400">#</th>
                            <th class="text-left px-6 py-4 text-sm font-medium text-gray-400">নাম</th>
                            <th class="text-left px-6 py-4 text-sm font-medium text-gray-400">ইমেইল</th>
                            <th class="text-left px-6 py-4 text-sm font-medium text-gray-400">ফোন</th>
                            <th class="text-left px-6 py-4 text-sm font-medium text-gray-400">রোল</th>
                            <th class="text-left px-6 py-4 text-sm font-medium text-gray-400">তারিখ</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-white/5">
                        @forelse($users as $user)
                        <tr class="hover:bg-white/5 transition-colors">
                            <td class="px-6 py-4 text-sm text-gray-400">{{ $user->id }}</td>
                            <td class="px-6 py-4">
                                <div class="flex items-center gap-3">
                                    <div class="w-10 h-10 bg-primary/20 rounded-full flex items-center justify-center">
                                        <span class="text-primary font-bold">{{ substr($user->name, 0, 1) }}</span>
                                    </div>
                                    <span class="font-medium">{{ $user->name }}</span>
                                </div>
                            </td>
                            <td class="px-6 py-4 text-sm">{{ $user->email }}</td>
                            <td class="px-6 py-4 text-sm">{{ $user->phone ?? '-' }}</td>
                            <td class="px-6 py-4">
                                @if($user->role === 'admin')
                                    <span class="bg-primary/20 text-primary px-3 py-1 rounded-full text-xs">অ্যাডমিন</span>
                                @else
                                    <span class="bg-gray-500/20 text-gray-400 px-3 py-1 rounded-full text-xs">ইউজার</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-400">
                                {{ $user->created_at->format('d M, Y') }}
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="6" class="px-6 py-8 text-center text-gray-400">
                                <i class="fas fa-inbox text-4xl mb-3"></i>
                                <p>কোনো ইউজার পাওয়া যায়নি</p>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        
        <div class="mt-6">
            {{ $users->links() }}
        </div>
    </div>
</section>
@endsection
