@extends('layouts.app')

@section('title', 'যোগাযোগ')

@section('content')
<!-- Page Header -->
<section class="py-20 bg-dark-light/50 relative overflow-hidden">
    <div class="absolute inset-0">
        <div class="absolute top-0 left-0 w-96 h-96 bg-primary/10 rounded-full filter blur-3xl"></div>
    </div>
    
    <div class="container mx-auto px-4 relative z-10">
        <div class="text-center max-w-2xl mx-auto">
            <span class="inline-block bg-primary/20 text-primary px-4 py-2 rounded-full text-sm font-medium mb-4">
                যোগাযোগ
            </span>
            <h1 class="text-3xl md:text-5xl font-bold mb-4">আমাদের সাথে যোগাযোগ করুন</h1>
            <p class="text-gray-400">
                যেকোনো প্রয়োজনে আমাদের সাথে যোগাযোগ করুন
            </p>
        </div>
    </div>
</section>

<!-- Contact Content -->
<section class="py-20 bg-dark">
    <div class="container mx-auto px-4">
        <div class="grid lg:grid-cols-3 gap-8">
            <!-- Contact Info -->
            <div class="lg:col-span-1 space-y-6">
                <div class="bg-dark-light rounded-2xl p-6 border border-white/10">
                    <div class="w-12 h-12 bg-primary/20 rounded-xl flex items-center justify-center mb-4">
                        <i class="fas fa-envelope text-primary text-xl"></i>
                    </div>
                    <h3 class="font-bold mb-2">ইমেইল</h3>
                    <p class="text-gray-400 text-sm mb-2">যেকোনো প্রশ্নের জন্য</p>
                    <a href="mailto:support@mamuneservice.com" class="text-primary hover:text-primary/80 transition-colors">
                        support@mamuneservice.com
                    </a>
                </div>
                
                <div class="bg-dark-light rounded-2xl p-6 border border-white/10">
                    <div class="w-12 h-12 bg-green-500/20 rounded-xl flex items-center justify-center mb-4">
                        <i class="fab fa-whatsapp text-green-400 text-xl"></i>
                    </div>
                    <h3 class="font-bold mb-2">হোয়াটসঅ্যাপ</h3>
                    <p class="text-gray-400 text-sm mb-2">দ্রুত সাপোর্টের জন্য</p>
                    <a href="https://wa.me/8801886191222" target="_blank" class="text-green-400 hover:text-green-300 transition-colors">
                        +8801886191222
                    </a>
                </div>
                
                <div class="bg-dark-light rounded-2xl p-6 border border-white/10">
                    <div class="w-12 h-12 bg-blue-500/20 rounded-xl flex items-center justify-center mb-4">
                        <i class="fab fa-telegram text-blue-400 text-xl"></i>
                    </div>
                    <h3 class="font-bold mb-2">টেলিগ্রাম</h3>
                    <p class="text-gray-400 text-sm mb-2">আপডেট পেতে</p>
                    <a href="https://t.me/mamuneservice" target="_blank" class="text-blue-400 hover:text-blue-300 transition-colors">
                        @mamuneservice
                    </a>
                </div>
                
                <div class="bg-dark-light rounded-2xl p-6 border border-white/10">
                    <h3 class="font-bold mb-4">সোশ্যাল মিডিয়া</h3>
                    <div class="flex gap-3">
                        <a href="https://facebook.com/mamuneservice" target="_blank" class="w-10 h-10 bg-blue-600 hover:bg-blue-700 rounded-lg flex items-center justify-center transition-colors">
                            <i class="fab fa-facebook-f"></i>
                        </a>
                        <a href="https://instagram.com/mamuneservice" target="_blank" class="w-10 h-10 bg-gradient-to-br from-purple-500 to-pink-500 hover:from-purple-600 hover:to-pink-600 rounded-lg flex items-center justify-center transition-colors">
                            <i class="fab fa-instagram"></i>
                        </a>
                        <a href="https://youtube.com/mamuneservice" target="_blank" class="w-10 h-10 bg-red-600 hover:bg-red-700 rounded-lg flex items-center justify-center transition-colors">
                            <i class="fab fa-youtube"></i>
                        </a>
                        <a href="https://linkedin.com/company/mamuneservice" target="_blank" class="w-10 h-10 bg-blue-700 hover:bg-blue-800 rounded-lg flex items-center justify-center transition-colors">
                            <i class="fab fa-linkedin-in"></i>
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- Contact Form -->
            <div class="lg:col-span-2">
                <div class="bg-dark-light rounded-2xl p-6 md:p-8 border border-white/10">
                    <h2 class="text-xl font-bold mb-6">মেসেজ পাঠান</h2>
                    
                    @if(session('success'))
                    <div class="bg-green-500/20 border border-green-500/50 text-green-400 px-4 py-3 rounded-xl mb-6">
                        <i class="fas fa-check-circle mr-2"></i>
                        {{ session('success') }}
                    </div>
                    @endif
                    
                    <form action="{{ route('contact') }}" method="POST">
                        @csrf
                        
                        <div class="grid md:grid-cols-2 gap-6 mb-6">
                            <div>
                                <label class="block text-sm font-medium mb-2">আপনার নাম <span class="text-red-500">*</span></label>
                                <input type="text" name="name" required class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="আপনার নাম">
                            </div>
                            <div>
                                <label class="block text-sm font-medium mb-2">ইমেইল <span class="text-red-500">*</span></label>
                                <input type="email" name="email" required class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="your@email.com">
                            </div>
                        </div>
                        
                        <div class="mb-6">
                            <label class="block text-sm font-medium mb-2">মোবাইল</label>
                            <input type="tel" name="phone" class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="০১XXXXXXXXX">
                        </div>
                        
                        <div class="mb-6">
                            <label class="block text-sm font-medium mb-2">বিষয় <span class="text-red-500">*</span></label>
                            <input type="text" name="subject" required class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="বিষয় লিখুন">
                        </div>
                        
                        <div class="mb-6">
                            <label class="block text-sm font-medium mb-2">বার্তা <span class="text-red-500">*</span></label>
                            <textarea name="message" rows="5" required class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="আপনার বার্তা লিখুন..."></textarea>
                        </div>
                        
                        <button type="submit" class="w-full bg-gradient-to-r from-primary to-secondary hover:from-primary/80 hover:to-secondary/80 text-white py-4 rounded-xl font-semibold transition-all duration-300 flex items-center justify-center gap-2">
                            <i class="fas fa-paper-plane"></i>
                            পাঠান
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
