@extends('layouts.app')

@section('title', 'Refund Policy')

@section('content')
<section class="py-20 bg-dark-light/50">
    <div class="container mx-auto px-4">
        <div class="max-w-3xl mx-auto">
            <h1 class="text-3xl md:text-4xl font-bold mb-8 text-center">Refund Policy</h1>
            
            <div class="bg-dark-light rounded-2xl p-6 md:p-8 border border-white/10 prose prose-invert max-w-none">
                <p class="text-gray-400 mb-6">সর্বশেষ আপডেট: {{ date('F Y') }}</p>
                
                <h2 class="text-xl font-bold mb-4">১. সাধারণ নীতি</h2>
                <p class="text-gray-400 mb-4">
                    Mamun eService-এ আমরা আমাদের গ্রাহকদের সন্তুষ্টি নিশ্চিত করতে চেষ্টা করি। তবে কিছু ক্ষেত্রে রিফান্ড প্রযোজ্য হতে পারে।
                </p>
                
                <h2 class="text-xl font-bold mb-4">২. রিফান্ডের যোগ্যতা</h2>
                <p class="text-gray-400 mb-4">নিম্নলিখিত পরিস্থিতিতে রিফান্ডের আবেদন করা যেতে পারে:</p>
                <ul class="text-gray-400 mb-4 list-disc list-inside">
                    <li>সেবা প্রদান করা না গেলে</li>
                    <li>প্রযুক্তিগত ত্রুটির কারণে সেবা ব্যর্থ হলে</li>
                    <li>ভুল তথ্য প্রদান করা হলে</li>
                </ul>
                
                <h2 class="text-xl font-bold mb-4">৩. রিফান্ডের সময়সীমা</h2>
                <p class="text-gray-400 mb-4">
                    রিফান্ডের আবেদন অর্ডার করার ৭ দিনের মধ্যে করতে হবে। ৭ দিন পরে কোনো রিফান্ড আবেদন গ্রহণ করা হবে না।
                </p>
                
                <h2 class="text-xl font-bold mb-4">৪. রিফান্ড প্রক্রিয়া</h2>
                <p class="text-gray-400 mb-4">
                    রিফান্ডের আবেদন করতে হলে আমাদের ইমেইলে যোগাযোগ করুন। আবেদন পর্যালোচনা করে ৩-৫ কার্যদিবসের মধ্যে সিদ্ধান্ত জানানো হবে।
                </p>
                
                <h2 class="text-xl font-bold mb-4">৫. রিফান্ড পদ্ধতি</h2>
                <p class="text-gray-400 mb-4">
                    অনুমোদিত রিফান্ড একই পেমেন্ট পদ্ধতিতে ফেরত দেওয়া হবে। রিফান্ড প্রক্রিয়াকরণে ৫-১০ কার্যদিবস সময় লাগতে পারে।
                </p>
                
                <h2 class="text-xl font-bold mb-4">৬. ব্যতিক্রম</h2>
                <p class="text-gray-400 mb-4">
                    নিম্নলিখিত ক্ষেত্রে রিফান্ড প্রযোজ্য নয়:
                </p>
                <ul class="text-gray-400 mb-4 list-disc list-inside">
                    <li>গ্রাহকের ভুল তথ্য প্রদানের কারণে সেবা ব্যর্থ হলে</li>
                    <li>সেবা গ্রহণ করার পর রিফান্ড আবেদন</li>
                    <li>অননুমোদিত পরিবর্তন বা মডিফিকেশন</li>
                </ul>
                
                <h2 class="text-xl font-bold mb-4">৭. যোগাযোগ</h2>
                <p class="text-gray-400">
                    রিফান্ড সংক্রান্ত যেকোনো প্রশ্নের জন্য: support@mamuneservice.com
                </p>
            </div>
        </div>
    </div>
</section>
@endsection
