@extends('layouts.app')

@section('title', 'সরকারি সেবা')

@section('content')
<!-- Page Header -->
<section class="py-20 bg-dark-light/50 relative overflow-hidden">
    <div class="absolute inset-0">
        <div class="absolute top-0 left-0 w-96 h-96 bg-primary/10 rounded-full filter blur-3xl"></div>
        <div class="absolute bottom-0 right-0 w-96 h-96 bg-secondary/10 rounded-full filter blur-3xl"></div>
    </div>
    
    <div class="container mx-auto px-4 relative z-10">
        <div class="text-center max-w-2xl mx-auto">
            <span class="inline-block bg-green-500/20 text-green-400 px-4 py-2 rounded-full text-sm font-medium mb-4">
                <i class="fas fa-landmark mr-2"></i>সরকারি সেবা
            </span>
            <h1 class="text-3xl md:text-5xl font-bold mb-4">সরকারি অনলাইন সেবাসমূহ</h1>
            <p class="text-gray-400">
                আপনার প্রয়োজনীয় সকল সরকারি সেবা এখন আরও সহজে ও দ্রুততার সাথে।
            </p>
        </div>
        
        <!-- Search Bar -->
        <div class="max-w-xl mx-auto mt-8">
            <form action="{{ route('services.index') }}" method="GET" class="relative">
                <input 
                    type="text" 
                    name="search" 
                    value="{{ $search ?? '' }}"
                    placeholder="সেবা খুঁজুন..." 
                    class="w-full bg-dark border border-white/10 rounded-xl px-5 py-4 pl-12 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors"
                >
                <i class="fas fa-search absolute left-4 top-1/2 -translate-y-1/2 text-gray-500"></i>
                <button type="submit" class="absolute right-2 top-1/2 -translate-y-1/2 bg-primary hover:bg-primary/80 text-white px-4 py-2 rounded-lg transition-colors">
                    খুঁজুন
                </button>
            </form>
        </div>
    </div>
</section>

<!-- Services Grid -->
<section class="py-20 bg-dark">
    <div class="container mx-auto px-4">
        @if($search)
        <div class="mb-6">
            <p class="text-gray-400">
                "{{ $search }}" এর জন্য {{ $services->total() }}টি ফলাফল পাওয়া গেছে
            </p>
        </div>
        @endif
        
        <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
            @forelse($services as $service)
            <div class="bg-dark-light rounded-2xl p-6 border border-white/10 hover:border-green-500/50 transition-all duration-300 hover:-translate-y-1">
                <div class="flex items-start gap-4 mb-4">
                    <div class="w-12 h-12 bg-green-500/20 rounded-xl flex items-center justify-center flex-shrink-0">
                        @if($service->icon)
                            <i class="{{ $service->icon }} text-xl text-green-400"></i>
                        @else
                            <i class="fas fa-file-alt text-xl text-green-400"></i>
                        @endif
                    </div>
                    <div>
                        <h3 class="text-lg font-bold mb-1">{{ $service->name_bn }}</h3>
                        <p class="text-gray-400 text-sm line-clamp-2">{{ $service->short_description_bn }}</p>
                    </div>
                </div>
                <a href="{{ url('/services/' . $service->slug) }}" class="inline-flex items-center text-green-400 hover:text-green-300 text-sm transition-colors">
                    বিস্তারিত দেখুন
                    <i class="fas fa-arrow-right ml-2"></i>
                </a>
            </div>
            @empty
            <div class="col-span-full text-center py-12">
                <div class="w-20 h-20 bg-white/5 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-search text-3xl text-gray-500"></i>
                </div>
                <h3 class="text-xl font-semibold mb-2">কোনো সেবা পাওয়া যায়নি</h3>
                <p class="text-gray-400">অনুগ্রহ করে অন্য কিছু দিয়ে খুঁজুন</p>
            </div>
            @endforelse
        </div>
        
        <!-- Pagination -->
        <div class="mt-10">
            {{ $services->links() }}
        </div>
    </div>
</section>
@endsection
